/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: Document.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.kdom;

import java.util.*;
import java.io.*;
import de.kxml.*;
import de.kxml.io.*;
import de.kxml.parser.*;

/**
 * The document consists of a prefix mapping and a root element
 */
public class Document {
    protected int	   rootIndex = -1;
    protected Hashtable    namespaceMap = new Hashtable();
    protected Vector       children = new Vector();
    protected StringBuffer types = new StringBuffer();

    /**
     * Method declaration
     *
     *
     * @param type
     * @param child
     *
     * @see
     */
    public void addChild(int type, Object child) {
	if (type == Xml.ELEMENT) {
	    rootIndex = children.size();
	} 

	types.append((char) type);
	children.addElement(child);
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @return
     *
     * @see
     */
    public Object getChild(int index) {
	return children.elementAt(index);
    } 

    /**
     * returns the document's map from namespaces to prefixes.
     * Attention: Consist
     */
    public Hashtable getNamespaceMap() {
	return namespaceMap;
    } 

    /**
     * Method declaration
     *
     *
     * @param namespace
     *
     * @return
     *
     * @see
     */
    public String getPrefix(String namespace) {
	return (String) namespaceMap.get(namespace);
    } 

    /**
     * Method declaration
     *
     *
     * @param index
     *
     * @return
     *
     * @see
     */
    public int getType(int index) {
	return (int) types.charAt(index);
    } 

    /**
     * elements should always be created using this method instead of
     * the constructor in order to enable construction of specialized
     * subclasses by deriving custom Document classes. Although a
     * parent node is given, the element is not inserted in the
     * corresponding tree by this method.
     */
    public Element createElement(Object parent, String namespace, 
				 String name, Vector attributes) {
	return new DefaultElement(parent, namespace, name, attributes);
    } 

    /**
     * returns the root element of this document
     */
    public Element getRootElement() {
	return (Element) getChild(rootIndex);
    } 

    /**
     * reads the content of the document from the given pullparser
     */
    public void parse(Parser parser) throws IOException {
	boolean leave = false;

	do {
	    ParseEvent event = parser.read();

	    switch (event.getType()) {

	    case Xml.START_TAG:
		StartTag childStart = (StartTag) event;
		Element  child = createElement(this, 
					       childStart.getNamespace(), 
					       childStart.getName(), 
					       childStart.getAttributes());

		// System.out.println("Document.parse(): Adding a start child, name:" + childStart.getName());
		addChild(Xml.ELEMENT, child);

		// order is important here since
		// setparent may perform some init code!
		child.parse(parser, childStart);

		break;

	    case Xml.TEXT: {
		String txt = event.getText();
		int    i = txt.length();

		while (i-- > 0) {
		    if (txt.charAt(i) > ' ') {
			throw new ParseException("Illegal Text at document level", 
						 parser.getLineNumber(), -1);

			// System.out.println("Element.parse(): Adding text child, name" + event.getText());;
		    } 
		}

		addChild(Xml.TEXT, event.getText());
	    } 

		break;

	    case Xml.END_DOCUMENT:
		leave = true;

		break;

	    case Xml.END_TAG:
		throw new RuntimeException("Unexpected end of document!");

	    default:

		// System.out.println("Element.parse(): Adding default child, name" + event.getText ());
		addChild(event.getType(), event.getText());
	    }
	} while (!leave);
    } 

    /**
     * sets the root element of this document
     * public void setRootElement (Element element) {
     * //if (root != null) root.setParent (null);
     * root = element;
     * }
     */

    /**
     * returns a string representation of this xml document
     */
    public String toString() {
	try {
	    ByteArrayOutputStream bos = new ByteArrayOutputStream();
	    XmlWriter		  xw = 
		new XmlWriter(new OutputStreamWriter(bos));

	    write(xw);
	    xw.close();

	    return new String(bos.toByteArray());
	} catch (IOException e) {
	    throw new RuntimeException("StringWriter shouldn't throw an IOException?!?");
	} 
    } 

    /**
     * writes this xml document to a stream. FIXME: Add namespace
     * declarations !!!!
     */
    public void write(XmlWriter writer) throws IOException {
	for (int i = 0; i < children.size(); i++) {
	    int    type = getType(i);
	    Object child = children.elementAt(i);

	    if (type == Xml.ELEMENT) {
		((Element) child).write(writer);
	    } else if (type == Xml.TEXT) {
		writer.write((String) child);
	    } else {
		writer.writeLegacy(type, ((String) child));
	    }
	} 

	writer.flush();
    } 

}

